function [exitFlag exitMsg netStruct] = ca_fixValue(netStruct, algorithmParameters, net2planParameters)

    % ca_fixValue
    %
    % Algorithm for capacity assignment problems which puts a fix capacity
    % value for all links.
    %
    % PARAM: capacityValue | 10 | Capacity in Erlangs (greater than 0)

    try
        %% Sanity checks
        capacityValue = checkAlgorithmParameters(algorithmParameters);
        assert(isfield(netStruct, 'linkCapacityInErlangs') && ~isempty(netStruct.linkCapacityInErlangs), ...
            'A set of links is required');
        
        %% Assign same capacity value to each link
        netStruct.linkCapacityInErlangs(1:end) = capacityValue;
        
        %% Remove obsolote routing information
        netStruct = removeRoutingInformation(netStruct);
        
        exitFlag = 0;
        exitMsg = 'OK!';
        
    catch e
        
        exitFlag = -1;
        exitMsg = e.message;
        netStruct = [];
        
    end

end

function capacityValue = checkAlgorithmParameters(algorithmParameters)

    try
        assert(isfield(algorithmParameters, 'capacityValue') && ~isempty(algorithmParameters.capacityValue), '"capacityValue" is required');
        capacityValue = str2double(algorithmParameters.capacityValue);
        assert(isfinite(capacityValue) && capacityValue > 0, '"capacityValue" must be greater than zero');
    catch e
        error('%s: %s', 'checkAlgorithmParameters', e.message);
    end
    
end