function [exitFlag exitMsg netStruct] = fa_shortestPath_km(netStruct, algorithmParameters, net2planParameters)

    % fa_shortestPath_km
    %
    % Algorithm for flow assignment problems which tries to route all traffic
    % by the shortest path using as cost per link its length in km.
    %
	% This algorithm has no specific parameters.
    
    try
        
        %% Sanity checks
        assert(isfield(netStruct, 'linkTable') && ~isempty(netStruct.linkTable), 'A link table is required');
        assert(isfield(netStruct, 'demandTable') && ~isempty(netStruct.demandTable), 'A demand set is required');
        
        %% Algorithm kernel
        D = size(netStruct.demandTable, 1);

        uniqueDemandTable = unique(netStruct.demandTable, 'rows');
        P = size(uniqueDemandTable, 1);
        
        x_dp = zeros(D, P);
        pathList = cell(1,P);
        
        for pathId = 1:P
            
            x_dp( ismember(netStruct.demandTable, uniqueDemandTable(pathId,:), 'rows'), pathId ) = 1;
            
            ingressNodeId = uniqueDemandTable(pathId, 1);
            egressNodeId = uniqueDemandTable(pathId, 2);
            
            sequenceOfLinks = shortestPath(netStruct.linkTable, netStruct.linkLengthInKm, ingressNodeId, egressNodeId);
            assert(~isempty(sequenceOfLinks), sprintf('No feasible path from %d to %d', ingressNodeId, egressNodeId));
            
            pathList{pathId} = sequenceOfLinks;
            
        end
        
        netStruct.pathList = pathList;
        netStruct.routingMatrix = x_dp;
		
        exitFlag = 0;
        exitMsg = 'OK!';
        
    catch e
        
        exitFlag = -1;
        exitMsg = e.message;
        netStruct = [];
        
    end

end