function [exitFlag exitMsg netStruct] = la_bidirectionalMinimumSpanningTree_Prim_Km(netStruct, algorithmParameters, net2planParameters)

    % la_bidirectionalMinimumSpanningTree_Prim_Km
    %
    % Algorithm for link assignment problems which generates a
    % bidirectional minimum spanning tree using Prim's algorithm and
    % link length as cost per link.
    %
    % PARAM: initialNode | 1 | Root node of the spanning tree

    try
        %% Sanity checks
        initialNode = checkAlgorithmParameters(algorithmParameters);
        assert(isfield(netStruct, 'nodeXYPositionTable'), 'A set of nodes is required');
        assert(isfield(algorithmParameters, 'initialNode'), 'An initial node is required');

        N = size(netStruct.nodeXYPositionTable, 1);
        assert(initialNode <= N, sprintf('initialNode must be between 1 and %d', N));

        [exitFlag exitMsg netStruct] = la_unidirectionalMinimumSpanningTree_Prim_Km(netStruct, algorithmParameters);
        
        assert(exitFlag == 0, exitMsg);
        
        %% Generate netStruct
        netStruct.linkTable = [netStruct.linkTable; netStruct.linkTable(:, [2 1])];
        netStruct.linkCapacityInErlangs = [netStruct.linkCapacityInErlangs netStruct.linkCapacityInErlangs];
        netStruct.linkLengthInKm = [netStruct.linkLengthInKm netStruct.linkLengthInKm];
        netStruct.linkAttributes = [netStruct.linkAttributes netStruct.linkAttributes];

        %% Remove routing information (now, it's obsolete)
        netStruct = removeRoutingInformation(netStruct);
        
    catch e
        
        exitFlag = -1;
        exitMsg = e.message;
        netStruct = [];

    end

end

function initialNode = checkAlgorithmParameters(algorithmParameters)

    try
        assert(isfield(algorithmParameters, 'initialNode') && ~isempty(algorithmParameters.initialNode), '"initialNode" is required');
        initialNode = str2double(algorithmParameters.initialNode);
        assert(isfinite(initialNode) && initialNode > 0 && initialNode == round(initialNode), '"initialNode" must be an non-negative non-zero integer');
    catch e
        error('%s: %s', 'checkAlgorithmParameters', e.message);
    end
    
end