function [exitFlag exitMsg netStruct] = la_randomUnidirectionalUntilConnected(netStruct, algorithmParameters, net2planParameters)

    % la_randomUnidirectionalUntilConnected
    %
    % Algorithm for link assignment problems which generates unidirectional
    % links until the network become connected.
    %
	% This algorithm has no specific parameters.

    try
        %% Sanity checks
        assert(isfield(netStruct, 'nodeXYPositionTable') && ~isempty(netStruct.nodeXYPositionTable), 'A set of nodes is required');
        
        %% Algorithm kernel
        N = size(netStruct.nodeXYPositionTable,1);
        linkTable = newLink(N);
        
        while ~isConnected(linkTable,1:N)
            linkTable = [linkTable; newLink(N)];
        end
     
        distanceMatrix = nodeXYPositionTable2distanceMatrix(netStruct.nodeXYPositionTable);

        E = size(linkTable, 1);
        netStruct.linkTable = linkTable;
        netStruct.linkCapacityInErlangs = zeros(1, E);
        netStruct.linkLengthInKm = distanceMatrix(sub2ind([N N], linkTable(:, 1), linkTable(:, 2)))';
        netStruct.linkAttributes = cellfun(@struct, cell(1, E), 'UniformOutput', false);
        
        netStruct = removeRoutingInformation(netStruct);
        
        exitFlag = 0;
        exitMsg = 'OK!';

    catch e
        
        exitFlag = -1;
        exitMsg = e.message;
        netStruct = [];
        
    end

end

function entry = newLink(N)

    entry = randi(N,[1 2]);
    while 1
        if entry(1) == entry(2)
            entry = randi(N,[1 2]);
        else
            break;
        end
    end
    
end