function [exitFlag exitMsg netStruct] = la_tspNearestNeighbourKmBidirectional(netStruct, algorithmParameters, net2planParameters)

    % la_tspNearestNeighbourKmBidirectional
    %
    % Algorithm for link assignment problems which generates a ring topology
    % using nearest neighbour with cost measured as Euclidean distance.
    %
	% This algorithm has no specific parameters.
	
    try
        %% Sanity checks
        assert(isfield(netStruct, 'nodeXYPositionTable') && ~isempty(netStruct.nodeXYPositionTable), 'A set of nodes is required');
        
        N = size(netStruct.nodeXYPositionTable, 1);
	
		distanceMatrix = nodeXYPositionTable2distanceMatrix(netStruct.nodeXYPositionTable);

        % Perform nearest neighbour computation
		initialNodeId = 1;
        nodeSequence = zeros(1, N+1);
        
        nodeSequence(1) = initialNodeId;
        previousNodeId = initialNodeId;
        candidatesForNextHop = 1:N;
        candidatesForNextHop(initialNodeId) = [];
        
        for hopId = 1:N-1
            [dummy, idx] = min(distanceMatrix(previousNodeId,candidatesForNextHop));
            previousNodeId = candidatesForNextHop(idx);
            candidatesForNextHop(idx) = [];
            nodeSequence(hopId+1) = previousNodeId;
        end
        
        nodeSequence(end) = initialNodeId;
		
		E = numel(nodeSequence)-1;
		netStruct.linkTable = zeros(2*E, 2);
		netStruct.linkCapacityInErlangs = zeros(1, 2*E);
		netStruct.linkLengthInKm = zeros(1, 2*E);
		netStruct.linkAttributes = cell(1, 2*E);

        for linkId = 1:E
			netStruct.linkTable(linkId, :) = [nodeSequence(linkId) nodeSequence(linkId+1)];
			netStruct.linkLengthInKm(linkId) = distanceMatrix(nodeSequence(linkId), nodeSequence(linkId+1));
			netStruct.linkAttributes{linkId} = struct();
			netStruct.linkTable(E + linkId, :) = [nodeSequence(linkId+1) nodeSequence(linkId)];
			netStruct.linkLengthInKm(E + linkId) = distanceMatrix(nodeSequence(linkId), nodeSequence(linkId+1));
			netStruct.linkAttributes{E + linkId} = struct();
        end
        
        netStruct = removeRoutingInformation(netStruct);
		
		exitFlag = 0;
		exitMsg = 'OK!';
		
    catch e
        
        exitFlag = -1;
        exitMsg = sprintf('Error message: %s', e.message);
        netStruct = [];
        
    end
end