function [exitFlag exitMsg netStruct] = na_topFiveSpain(netStruct, algorithmParameters, net2planParameters)

	% na_topFiveSpain
	%
	% Algorithm for node assignment problems which gives a set of nodes
	% (along with "population" attribute), one of them representing the
	% five largest cities in Spain (in terms of population).
	%
	% This algorithm will remove any previous information in netStruct
	% and has no specific parameterss.

    netStruct = struct();
	 
    topFive = { 'Madrid', 40.418889, -3.691944, 3265038;
        'Barcelona', 41.3825, 2.176944, 1615448;
        'Valencia', 39.47, -0.376667, 798033;
        'Sevilla', 37.383056, -5.996389, 703021;
        'Zaragoza', 41.65, -0.883333, 674725 };

	N = size(topFive, 1);
    netStruct.nodeName = topFive(:,1)';
    nodeXYPositionTableInLatLon = cell2mat(topFive(:,3:-1:2));
    
    % Conversion from lat/lon to km using nautic mile definition
    % and first node as origin. Give us an approximate value assuming
    % nodes are aligned along the equator
    nodeXYPositionTableInLatLon = nodeXYPositionTableInLatLon - ...
        repmat(nodeXYPositionTableInLatLon(1,:), N, 1);
    netStruct.nodeXYPositionTable = 60 * 1.852 * nodeXYPositionTableInLatLon;
	
    netStruct.nodeAttributes = cell(1,N);
    for nodeId = 1:N
        netStruct.nodeAttributes{nodeId} = struct('population', num2str(topFive{nodeId, 4}), 'level', '1');
    end

    exitFlag = 0;
    exitMsg = 'OK!';
    
end