classdef HButtonBoxFitButton < uiextras.HButtonBox

    methods
        
        function obj = HButtonBoxFitButton( varargin )
            obj@uiextras.HButtonBox( varargin{:} );

            if nargin > 0
                set( obj, varargin{:} );
            end
        end % constructor
        
    end
        
	methods (Access = protected)
        function redraw( obj )
            % First we need to work out how much space is available - if
            % there's not enough for the desired size then the buttons may
            % have to shrink
            children = obj.getValidChildren();
            nChildren = numel( children );
            if nChildren == 0, return; end
            pos = ceil( getpixelposition( obj.UIContainer ) );
            availableWidth = pos(3) - 2*obj.Padding - (nChildren-1)*obj.Spacing;
            availableHeight = pos(4) - 2*obj.Padding;
            
			buttonWidth = zeros(1, nChildren);
            for childrenId = 1:nChildren
                if ismember(get(children(childrenId), 'Style'), {'text', 'pushbutton'})
					extent = get(children(childrenId), 'Extent');
					buttonWidth(childrenId) = extent(3)+2;
                elseif strcmp(get(children(childrenId), 'Style'), 'edit')
                    buttonWidth(childrenId) = 50;
                end
                
                availableWidth = availableWidth - buttonWidth(childrenId);
            end
            
            if any(buttonWidth == 0), buttonWidth(buttonWidth == 0) = availableWidth / sum(buttonWidth == 0); end
            buttonHeight = min( obj.ButtonSize(2), availableHeight );
            
            % The positioning depends on the alignment
            switch upper( obj.VerticalAlignment )
                case 'TOP'
                    y0 = pos(4) - obj.Padding - buttonHeight;
                    
                case 'MIDDLE'
                    y0 = 1 + round( ( pos(4) - buttonHeight ) / 2 );
                    
                case 'BOTTOM'
                    y0 = 1 + obj.Padding;
                    
                otherwise
                    error( 'GUILayout:InvalidState', ...
                        'Invalid vertical alignment ''%s''.', obj.VerticalAlignment )
            end
            
            buttonsWidth = sum(buttonWidth) + (nChildren-1)*obj.Spacing;
            
            switch upper( obj.HorizontalAlignment )
                case 'LEFT'
                    x0 = 1+ obj.Padding;
                    
                case 'CENTER'
                    x0 = 1 + round( (pos(3) - buttonsWidth ) / 2 );
                    
                case 'RIGHT'
                    x0 = pos(3) - obj.Padding - buttonsWidth;
                    
                otherwise
                    error( 'GUILayout:InvalidState', ...
                        'Invalid horizontal alignment ''%s''.', obj.HorizontalAlignment )
                    
            end
			
	
            
            % OK, we now know the start coords, so position each child
            children = obj.Children;
            for ii=1:nChildren
                contentPos = [x0 + (ii-1)*obj.Spacing + sum(buttonWidth(1:ii-1)), y0, buttonWidth(ii), buttonHeight];
                obj.repositionChild( children(ii), contentPos )
            end
            
        end % redraw
     
    end % protected methods
    
end % classdef