function yesNo = isBidirectional(linkTable)

    % isBidirectional
    %
    % Check whether the topology is bidirectional: same number
	% of links between each node pair in both directions (assuming
	% multi-digraphs)
    %
    % Syntax: yesNo = isBidirectional(linkTable)
    %
    % Input parameters:
    % - linkTable (Ex2): A table in which each row represents
	%   the origin and the destination nodes of the link
    %
    % Output parameters:
    % - yesNo: '1' if is bidirectional, '0' if not

    try
        
        %% Sanity checks
        assert(nargin == 1, 'The number of input arguments must be 1');
        assert(all(isfinite(linkTable(:))) && all(linkTable(:) == round(linkTable(:))) && ...
            ndims(linkTable) == 2 && ...
            size(linkTable, 2) == 2 && ...
			min(linkTable(:)) > 0, ...
            'linkTable must be a non-negative non-zero integer Ex2 matrix');
		
        %% Check symmetry using adjacency matrix
		N = max(linkTable(:));
		adjacencyMatrix = linkTable2adjacencyMatrix(linkTable, N);
		yesNo = isequal(adjacencyMatrix, adjacencyMatrix');
		
    catch e
        
        error('%s: %s', mfilename, e.message);
        
    end

end