function yesNo = isSimpleGraph(linkTable)

    % isSimpleGraph
    %
    % Check whether is a graph is simple: no more than one link
	% per node pair
    %
    % Syntax: yesNo = isSimpleGraph(linkTable)
    %
    % Input parameters:
    % - linkTable (Ex2): A table in which each row represents
	%   the origin and the destination nodes of the link
    %
    % Output parameters:
    % - yesNo: '1' if is simple, '0' if not

    try
        
        %% Sanity checks
        assert(nargin == 1, 'The number of input arguments must be 1');
        assert(all(isfinite(linkTable(:))) && all(linkTable(:) == round(linkTable(:))) && ...
            ndims(linkTable) == 2 && ...
            size(linkTable, 2) == 2 && ...
			min(linkTable(:)) > 0, ...
            'linkTable must be a non-negative non-zero integer Ex2 matrix');
		
        %% Perform check
		yesNo = isequal(size(unique(linkTable, 'rows')),size(linkTable));

    catch e
        
        error('%s: %s', mfilename, e.message);
        
    end

end