function [linkTable, linkCostVector] = primAlgorithm(costMatrix, initialNode)

	% primAlgorithm
	%
	% Function to generate a minimum spanning tree using Prim's algorithm
	%
	% Input parameters:
	% - costMatrix (NxN): Each entry (i,j) represents the cost to go
	%   from i to j. Each value must be a non-negative number.
	%
	% To represent that there is no direct connection between i and j
	% its associated entry must be equal to 0
	%
	% Output parameters:
	% - linkTable (Ex2): Each row represents a link
	% - linkCostVector (1xE): Row vector with link cost
	
	try
		%% Sanity checks
		assert(nargin == 2, 'The number of input parameters must be 2');
		assert(~isempty(costMatrix) && all(isfinite(costMatrix(:))) && ...
			ndims(costMatrix) == 2 && size(costMatrix, 1) == size(costMatrix, 2), ...
			'costMatrix must be a square non-negative matrix');
		N = size(costMatrix, 1);
		assert(~isempty(initialNode) && numel(initialNode) == 1 && ...
			isfinite(initialNode) && initialNode > 0 && initialNode < N, ...
			sprintf('initialNode must be in range [1, %d]', N));
		
		%% Compute MST
		costMatrix(costMatrix == 0) = inf;
		if all(costMatrix == inf)
			linkTable = [];
			linkCostVector = [];
			return;
		end
		
        k=1:N;
        listV(k)=0;
        listV(initialNode)=1;
        e=1;
        
        source = zeros(1, N-1);
        destination = zeros(1, N-1);
        distance = zeros(1, N-1);
        
        while (e<N)
            min=inf;
             for i=1:N
                if listV(i)==1
                    for j=1:N
                        if listV(j)==0
                           if min>costMatrix(i,j)
                                min=costMatrix(i,j);
                                b=costMatrix(i,j);
                                s=i;
                                d=j;
                            end
                        end
                    end
                end
            end
            listV(d)=1;
            source(e)=s;
            destination(e) = d;
            distance(e) = b;
            e=e+1;
        end
		
        linkTable = [source' destination'];
        linkCostVector = distance;	
	
	catch e
		error('%s: %s', mfilename, e.message);
	end

end