function sequenceOfNodes = sequenceOfLinks2sequenceOfNodes(linkTable, sequenceOfLinks)

	% sequenceOfLinks2sequenceOfNodes
	%
	% Given a linkTable and a sequenceOfLinks, return the sequenceOfNodes
	% traversed
	%
	% Syntax: sequenceOfNodes = sequenceOfLinks2sequenceOfNodes(linkTable, sequenceOfLinks)
	%
	% Input parameters:
	% - linkTable (Ex2): Table in which each row represents the origin and destination
	%   node of the link
	% - sequenceOfLinks: Row vector with a feasible sequence of links
	%
	% Output parameters:
	% - sequenceOfNodes: Nodes traversed by sequenceOfLinks

    try
        %% Sanity checks
		assert(nargin == 2, 'The number of input arguments must be 2');
		assert(~isempty(linkTable) && all(isfinite(linkTable(:))) && ndims(linkTable) == 2 && ...
			size(linkTable, 2) == 2 && all(linkTable(:) > 0), 'linkTable must be a non-negative non-zero Ex2 table');
		E = size(linkTable, 1);
		assert(~isempty(sequenceOfLinks) && all(isfinite(sequenceOfLinks(:))) && ndims(sequenceOfLinks) == 2 && ...
			size(sequenceOfLinks, 1) == 1 && all(sequenceOfLinks(:) > 0) && all(sequenceOfLinks(:) <= E), ...
			sprintf('sequenceOfLinks must be a valid row vector with each value in range [1, %d]', E));
		
		%% Get sequenceOfNodes
        sourceNodes = linkTable(sequenceOfLinks, 1);
        destinationNodes = linkTable(sequenceOfLinks, 2);
        
        assert(isequal(sourceNodes(2:end), destinationNodes(1:end-1)), 'Sequence of links not feasible');
        
        sequenceOfNodes = [sourceNodes; destinationNodes(end)]';
        
    catch e
        
        error('%s: %s', mfilename, e.message);
        
    end

end