function [x_dp pathList] = xde2xdp(x_de, linkTable, costPerLink, demandTable)

    try

        PRECISIONFACTOR = 1e-3;

        D = size(demandTable, 1);

        x_dp = sparse(D,1);
        numberOfPaths = 0;
        pathList = [];

        for demandId = 1:D

            P_d = [];

            while sum(x_dp(demandId, P_d)) < 1 - PRECISIONFACTOR

                linksCarryingTraffic = find( x_de(demandId, :) > 0);
                if isempty(linksCarryingTraffic), break; end

                auxLinkTable = [linkTable(linksCarryingTraffic, :) costPerLink(linksCarryingTraffic)'];

                p = shortestPath(linkTable(linksCarryingTraffic, :), ...
                    costPerLink(linksCarryingTraffic), ...
                    demandTable(demandId, 1), ...
                    demandTable(demandId, 2));

                assert(~isempty(p), 'A feasible path can''t be found');

                if numberOfPaths > 0, x_dp = [x_dp sparse(D, 1)]; end
                numberOfPaths = numberOfPaths + 1;

                pathList = [pathList {linksCarryingTraffic(p)}];
                P_d = [P_d numberOfPaths];

                trafficInPath = min(x_de(demandId, linksCarryingTraffic(p)));
                x_dp(demandId, numberOfPaths) = trafficInPath;
                x_de(demandId, linksCarryingTraffic(p)) = x_de(demandId, linksCarryingTraffic(p)) - trafficInPath;

            end

        end
    
    catch e
        error('%s: %s', mfilename, e.message);
    end

end