function netStruct = removeRoutingInformation(netStruct)

	% removeRoutingInformation
	%
	% Function to remove routing information from netStruct
	% when due to any operation (as a link capacity change), that
	% becomes obsolete.
	%
	% Syntax: netStruct = removeRoutingInformation(netStruct)
	%
	% Input parameters:
	% - netStruct: A valid netStruct
	%
	% Output parameters:
	% - netStruct: Same input netStruct without routing information

    try
		assert(nargin == 1, 'Number of input parameters must be 1');
        if isfield(netStruct, 'pathList'), netStruct = rmfield(netStruct, 'pathList'); end
        if isfield(netStruct, 'routingMatrix'), netStruct = rmfield(netStruct, 'routingMatrix'); end
    catch e
        error('%s: %s', mfilename, e.message);
    end

end